/*

  First Configuration

  This sketch demonstrates the usage of MKR WAN 1300/1310 LoRa module.

  This example code is in the public domain.

*/

#include <MKRWAN.h>

LoRaModem modem;

// Uncomment if using the Murata chip as a module
// LoRaModem modem(Serial1);

String appEui="xxxxxxxxxxxxxxxxxxxx";

String appKey="xxxxxxxxxxxxxxxxxxxxxxxxxxxx";

String devEUI="xxxxxxxxxxxxxxxxxxxx";

int err;

void setup() {
  
   int connected;
  // put your setup code here, to run once:

  Serial.begin(115200);

  while (!Serial);

  Serial.println("Welcome to MKRWAN1300/1310 first configuration sketch");

  Serial.println("Register to your favourite LoRa network and we are ready to go!");

  // change this to your regional band (eg. US915, AS923, ...)

  if (!modem.begin(EU868)) {

    Serial.println("Failed to start module");

    while (1) {}

  };

  Serial.print("Your module version is: ");

  Serial.println(modem.version());

  Serial.print("Your device EUI is: ");

  Serial.println(modem.deviceEUI());

  
  
  connected = modem.joinOTAA(appEui, appKey);

  if (!connected) {

    Serial.println("Something went wrong; are you indoor? Move near a window and retry");

    while (1) {}

  }

  modem.minPollInterval(60);

  delay(5000);

}

void loop() {

  while (modem.available()) {

    Serial.write(modem.read());

  }

   

  modem.setPort(1);

  modem.beginPacket();

  uint16_t data = 12; //our data
  byte buffer[1];    //prepare the buffer
  
  buffer[0] = data; // insert data into buffer

  modem.write(buffer,1); //send data

  err = modem.endPacket(true);

  if (err > 0) {

    Serial.println("Message sent correctly!");

  } else {

    Serial.println("Error sending message :(");

  }
  delay(10000);
}
